local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function RandBetween(a, b)
	local r = rand()
	local d = b-a
	local e = d*r
	return a + e
end

function BreakSound(self)
	--PlaySound("GAME_CRATEBREAK")
	local r = rand()
	if r <= 0.3 then
		PlaySound("CUSTOM_TRIGGER_POT1")
	elseif r <= 0.6 then
		PlaySound("CUSTOM_TRIGGER_POT2")
	elseif r <= 0.9 then
		PlaySound("CUSTOM_TRIGGER_POT3")
	else
		PlaySound("CUSTOM_TRIGGER_POT4")
	end
end

function init(self) 
	self.HitRect = {-16,-32,16,32}
	self.HitTypeFlags = 50335794+64
	--self.HitTypeFlags = ObjectType.Player
	--self.AttackRect = {-16,-16,16,16}
    --self.AttackTypeFlags = ObjectType.Player
	rt = TranslateTreasure(self.Health)
	if rt >= 0 then
		RegisterTreasure(TranslateTreasure(self.Health))
	end
	self.ObjectTypeFlags = 4
	
	-- coins: 708
end

function TranslateTreasure(hp)
	res = -1
	if (hp==0 or hp==33) then --coin
		res = 0
	elseif (hp==1) then -- goldbar
		res = 1
	elseif (hp==2 or hp==3 or hp==4 or hp==5 ) then -- ring
		res = 2
	elseif (hp==41 or hp==42 or hp==43 or hp==44 ) then -- chalice
		res = 3
	elseif (hp==7 or hp==8 or hp==9 or hp==10 ) then -- cross
		res = 4
	elseif (hp==11 or hp==12 or hp==13 or hp==14 ) then -- scepter
		res = 5
	elseif (hp==15 or hp==16 or hp==17 or hp==18 ) then -- gecko
		res = 6
	elseif (hp==45 or hp==46 or hp==47 or hp==48 ) then -- crown
		res = 7
	elseif (hp==49 or hp==50 or hp==51 or hp==52 ) then -- scull
		res = 8
	end
	return res
end

function main(self)
	if (self.State == 0) then 
		if self.Smarts == 0 then
			self:SetImage("CUSTOM_WAZA_WYSOKA")
		end
		self:SetAnimation("GAME_FORWARD100")
		self.SparkDelay = GetTime() + rand()*2000 + 1000
		self.State = 1
	end 
	local claw = GetClaw() 
	
	if (self.State == 1) then 
		if GetTime() > self.SparkDelay then
			CreateObject {x=math.ceil(self.X+RandBetween(-10, 10)), y=math.ceil(self.Y+RandBetween(-20, 20)), z=9000, name="Spark", logic="CustomLogic", image="GAME_SPARKLE"}
			self.SparkDelay = GetTime() + rand()*2000 + 1000
		end
	end
	
	if (self.State == 2) then 
		self:AnimationStep() 
		if self.I == 8 and self.t+500>GetTime() then 
			self:Destroy()
		end
		if self.I < 8 then
			self.t = GetTime()
		end
	end	
	if (self.State == 3) then 
		
		self:AnimationStep() 
		if self.I == 18 then 
			if rand() < 0.5 then
				shatter = CreateObject {x=self.X+71, y=self.Y, z=self.z, logic="AniCycle", image="CUSTOM_WAZA_WYSOKA_RIGHT_SHATTER"}
			else
				shatter = CreateObject {x=self.X+71, y=self.Y, z=self.z, logic="AniCycle", image="CUSTOM_WAZA_WYSOKA_RIGHT_SHATTER2"}
			end
			shatter:SetAnimation("GAME_FORWARD50") 
			BreakSound(self)
			CreateGoodie {x=self.X+42, y=self.Y, z=self.Z+1, powerup=self.Health}
			self:Destroy()
		end
	end	
	if (self.State == 4) then 
		
		self:AnimationStep() 
		if self.I == 18 then
			if rand() < 0.5 then
				shatter = CreateObject {x=self.X-71, y=self.Y, z=self.z, logic="AniCycle", image="CUSTOM_WAZA_WYSOKA_LEFT_SHATTER"}
			else
				shatter = CreateObject {x=self.X-71, y=self.Y, z=self.z, logic="AniCycle", image="CUSTOM_WAZA_WYSOKA_LEFT_SHATTER2"}
			end
			shatter:SetAnimation("GAME_FORWARD50") 
			CreateGoodie {x=self.X-42, y=self.Y, z=self.Z+1, powerup=self.Health}
			BreakSound(self)
			self:Destroy()
		end
	end	
		
	if GetClaw().X >= self.X-8 and GetClaw().X <= self.X+8 and GetClaw().Y>= self.Y-48 and GetClaw().Y <= self.Y+16 and self.Smarts == 0 then
		if self.State == 1 and GetClaw().DrawFlags.Mirror == false then
			self.State = 3
			self:SetImage("CUSTOM_WAZA_WYSOKA_RIGHT")
			self:SetAnimation("GAME_FORWARD50") 
			self.Y = self.Y - 7
			--CreateGoodie {x=self.X, y=self.Y, z=self.Z+1, powerup=0}
		elseif self.State == 1 and GetClaw().DrawFlags.Mirror == true then
			self.State = 4
			self:SetImage("CUSTOM_WAZA_WYSOKA_LEFT")
			self:SetAnimation("GAME_FORWARD50") 
			self.Y = self.Y - 7
		end
	end
end

--prewracanie: 3675,2454
--norm: 3675, 2461

function hit(self) -- uderzenie szablą
	if self.State == 1 then
		
		if self.HitRef.ObjectTypeFlags == 32 then
			self.HitRef.Y = 9900
		end
		
		self.State = 2
		CreateGoodie {x=self.X, y=self.Y, z=self.Z+1, powerup=self.Health}
		BreakSound(self)
	end
end 

